package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.LotteryResultAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentLotteryResultBinding;
import app.firezone.synk.network.model.BannerModel;
import app.firezone.synk.network.model.LotteryModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


public class LotteryResultFragment extends Fragment {

    FragmentLotteryResultBinding binding;

    ArrayList<LotteryModel> mlist = new ArrayList<LotteryModel>();
    LotteryResultAdapter myAdapter;

    private  MyApi myApi;
    FirebaseDatabase database;
    Dialog dialog;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding =  FragmentLotteryResultBinding.inflate(inflater, container, false);
        View view = binding.getRoot();


        database = FirebaseDatabase.getInstance();

        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.loading_dialog);



        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();

        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<List<BannerModel>> call = myApi.fetchBanner();
        call.enqueue(new Callback<List<BannerModel>>() {
            @Override
            public void onResponse(Call<List<BannerModel>> call, Response<List<BannerModel>> response) {
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    // Assuming the first item in the response is the Wallet Banner
                    BannerModel model = response.body().get(0);

                    Picasso.get()
                            .load(model.getUrl())
                            .placeholder(R.drawable.loading_img)
                            .into(binding.lotteryBannerImg);
                } else {
                    Toast.makeText(getContext(), "No banner found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<List<BannerModel>> call, Throwable t) {
                Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });

        binding.loterryResultRecy.setLayoutManager(new LinearLayoutManager(getContext()));

        fetchLotteryData();

        return  view;
    }

    private void fetchLotteryData() {

        if (getContext() == null) {
            Toast.makeText(getContext(), "Context is null. Please restart the app.", Toast.LENGTH_SHORT).show();
            return;
        }

        dialog.show();

        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ArrayList<LotteryModel>> call = myApi.fetchLottery();

        call.enqueue(new Callback<ArrayList<LotteryModel>>() {
            @Override
            public void onResponse(Call<ArrayList<LotteryModel>> call, Response<ArrayList<LotteryModel>> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {

                    ArrayList<LotteryModel> allLotteries = response.body();
                    List<LotteryModel> ongoingLotteries = new ArrayList<>();

                    for (LotteryModel model : allLotteries) {
                        if ("Result".equalsIgnoreCase(Objects.toString(model.getStatus(), ""))) {
                            ongoingLotteries.add(model);
                        }
                    }

                    if (!ongoingLotteries.isEmpty()) {
                        if (binding.loterryResultRecy.getLayoutManager() == null) {
                            binding.loterryResultRecy.setLayoutManager(new LinearLayoutManager(getContext()));
                        }
                        myAdapter = new LotteryResultAdapter(getContext(), new ArrayList<>(ongoingLotteries));
                        binding.loterryResultRecy.setAdapter(myAdapter);
                    } else {
                        Toast.makeText(getContext(), "No ongoing lotteries available.", Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(getContext(), "Failed to fetch lottery data. Error: " + response.code(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<LotteryModel>> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(getContext(), "Network error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

}